<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Admin Dashboard - Fees Payments</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<!-- Sidebar and Dashboard Content -->
<div class="d-flex" id="wrapper">
  <!-- Sidebar -->
  <div class="bg-dark text-white" id="sidebar-wrapper">
    <div class="sidebar-heading text-center py-4 fs-4 fw-bold text-uppercase border-bottom">School Admin</div>
    <div class="list-group list-group-flush my-3">
      <a href="#" class="list-group-item list-group-item-action bg-dark text-white fw-bold">Dashboard</a>
      <a href="admin_add_fee_payment.php" class="list-group-item list-group-item-action bg-dark text-white fw-bold">Add Payments</a>
      <a href="admin_view_fees_amount.php" class="list-group-item list-group-item-action bg-dark text-white fw-bold">View Fees Amounts</a>
      <a href="#" class="list-group-item list-group-item-action bg-dark text-white fw-bold">Reports</a>
      <a href="#" class="list-group-item list-group-item-action bg-dark text-white fw-bold">Settings</a>
    </div>
  </div>


  <!-- Page Content -->
  <div id="page-content-wrapper" class="w-100">
    <nav class="navbar navbar-expand-lg navbar-light bg-light border-bottom">
      <div class="container-fluid">
        <button class="btn btn-dark" id="menu-toggle">Toggle Menu</button>
        <h4 class="ms-3">Mwalongo Secondary School Payments Dashboard</h4>
        <button class="btn btn-primary ms-auto" data-bs-toggle="modal" data-bs-target="#paymentModal">Add Payment</button>
        <a href="school_logout.php" class="btn btn-outline-danger ms-2">Logout</a>
      </div>
    </nav>

    <!-- Dashboard Cards -->
    <div class="container-fluid px-4 mt-4">
      <div class="row">


        <div class="col-md-3 mb-3">
          <div class="card text-white bg-success mb-3">
            <div class="card-body">
              <h5 class="card-title">Completed Payments</h5>
              <h3>450</h3>
            </div>
          </div>
        </div>
        <div class="col-md-3 mb-3">
          <div class="card text-white bg-secondary mb-3">
            <div class="card-body">
              <h5 class="card-title">Partial Payments</h5>
              <h3>120</h3>
            </div>
          </div>
        </div>
        <div class="col-md-3 mb-3">
          <div class="card text-white bg-warning mb-3">
            <div class="card-body">
              <h5 class="card-title"> Not Paid </h5>
              <h3>80</h3>
            </div>
          </div>
        </div>
      </div>
    </div>
<?php
include 'connection.php'; // Include database connection

// Set the number of records per page
$records_per_page = 10;

// Get the current page from URL, if not set, default to page 1
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$start_from = ($page - 1) * $records_per_page;

// Handle search
$search = isset($_POST['search']) ? $_POST['search'] : '';

// Fetch payment data with student details (with search condition if applicable)
$query = "SELECT *
          FROM fees_payments f
          INNER JOIN students s ON f.registration_number = s.registration_number
          WHERE s.registration_number LIKE '%$search%' OR s.full_name LIKE '%$search%' OR s.class LIKE '%$search%' OR f.payment_date LIKE '%$search%'
          ORDER BY f.payment_date DESC
          LIMIT $start_from, $records_per_page";

$result = $con->query($query);

// Get the total number of records for pagination
$total_query = "SELECT COUNT(*) AS total FROM fees_payments f INNER JOIN students s ON f.registration_number = s.registration_number
                WHERE s.registration_number LIKE '%$search%' OR s.full_name LIKE '%$search%' OR s.class LIKE '%$search%' OR f.payment_date LIKE '%$search%'";
$total_result = $con->query($total_query);
$total_row = $total_result->fetch_assoc();
$total_records = $total_row['total'];
$total_pages = ceil($total_records / $records_per_page);
?>

<!-- Payments Table with Search and Pagination -->
<div class="container-fluid px-4 mt-4">
    <div class="card">
        <div class="card-header bg-dark text-white">Recent Payments</div>
        <div class="card-body">
            <!-- Search Form -->
            <form method="POST" class="mb-3">
                <div class="input-group">
                    <input type="text" class="form-control" name="search" placeholder="Search by registration number, name, class, or date" value="<?php echo htmlspecialchars($search); ?>">
                    <button type="submit" class="btn btn-primary">Search</button>
                </div>
            </form>

            <!-- Payments Table -->
            <table class="table table-bordered table-striped">
                <thead class="table-dark">
                    <tr>
                        <th>#</th>
                        <th>Registration Number</th>
                        <th>Student Name</th>
                        <th>Student Class</th>
                        <th>Payment Date</th>
                        <th>Payment Method</th>
                        <th>Tuition Fee (TZS)</th>
                        <th>Other Fee(TZS)</th>
                        <th>Amount (TZS)</th>
                        <th>Balance Due (TZS)</th>
                        <th>Payment Status</th>
                        <th>Actions</th> <!-- Added Actions Column -->
                    </tr>
                </thead>
                <tbody>
                    <?php
                    if ($result->num_rows > 0) {
                        $count = $start_from + 1;
                        while ($row = $result->fetch_assoc()) {
                            $badgeClass = ($row['payment_status'] == 'Completed') ? 'bg-success' : 'bg-warning';
                            echo "<tr>
                                    <td>{$count}</td>
                                    <td>{$row['registration_number']}</td>
                                    <td>{$row['full_name']}</td>
                                    <td>{$row['class']}</td>
                                    <td>{$row['payment_date']}</td>
                                    <td>{$row['payment_method']}</td>
                                    <td>" . number_format($row['tuition_fee'], 2) . "</td>
                                    <td>" . number_format($row['other_fee'], 2) . "</td>
                                    <td>" . number_format($row['amount_paid'], 2) . "</td>
                                    <td>" . number_format($row['balance_due'], 2) . "</td>
                                    <td><span class='badge $badgeClass'>{$row['payment_status']}</span></td>
                                    <td>
                                        <a href='edit_payment.php?id={$row['id']}' class='btn btn-warning btn-sm'>Edit</a> 
                                        <a href='delete_payment.php?id={$row['id']}' class='btn btn-danger btn-sm' onclick='return confirm(\"Are you sure you want to delete this payment?\")'>Delete</a>
                                    </td> <!-- Edit and Delete Buttons -->
                                  </tr>";
                            $count++;
                        }
                    } else {
                        echo "<tr><td colspan='12' class='text-center'>No payments found</td></tr>";
                    }
                    ?>
                </tbody>
            </table>

            <!-- Pagination -->
            <nav aria-label="Page navigation">
                <ul class="pagination justify-content-center">
                    <li class="page-item <?php echo ($page == 1) ? 'disabled' : ''; ?>">
                        <a class="page-link" href="?page=<?php echo $page - 1; ?>" aria-label="Previous">Previous</a>
                    </li>
                    <?php
                    for ($i = 1; $i <= $total_pages; $i++) {
                        echo "<li class='page-item " . ($i == $page ? 'active' : '') . "'><a class='page-link' href='?page=$i'>$i</a></li>";
                    }
                    ?>
                    <li class="page-item <?php echo ($page == $total_pages) ? 'disabled' : ''; ?>">
                        <a class="page-link" href="?page=<?php echo $page + 1; ?>" aria-label="Next">Next</a>
                    </li>
                </ul>
            </nav>
        </div>
    </div>
</div>

<br><br>

<!-- Scripts -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
